<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Basic vault instruction specification that can be extended by specific payment sources that supports
 * vaulting.
 */
class VaultInstructionBase implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $storeInVault;

    /**
     * Returns Store in Vault.
     * Defines how and when the payment source gets vaulted.
     */
    public function getStoreInVault(): ?string
    {
        return $this->storeInVault;
    }

    /**
     * Sets Store in Vault.
     * Defines how and when the payment source gets vaulted.
     *
     * @maps store_in_vault
     */
    public function setStoreInVault(?string $storeInVault): void
    {
        $this->storeInVault = $storeInVault;
    }

    /**
     * Converts the VaultInstructionBase object to a human-readable string representation.
     *
     * @return string The string representation of the VaultInstructionBase object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('VaultInstructionBase', ['storeInVault' => $this->storeInVault]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->storeInVault)) {
            $json['store_in_vault'] = $this->storeInVault;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
