<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The tax ID of the customer. The customer is also known as the payer. Both `tax_id` and `tax_id_type`
 * are required.
 */
class TaxInfo implements \JsonSerializable
{
    /**
     * @var string
     */
    private $taxId;

    /**
     * @var string
     */
    private $taxIdType;

    /**
     * @param string $taxId
     * @param string $taxIdType
     */
    public function __construct(string $taxId, string $taxIdType)
    {
        $this->taxId = $taxId;
        $this->taxIdType = $taxIdType;
    }

    /**
     * Returns Tax Id.
     * The customer's tax ID value.
     */
    public function getTaxId(): string
    {
        return $this->taxId;
    }

    /**
     * Sets Tax Id.
     * The customer's tax ID value.
     *
     * @required
     * @maps tax_id
     */
    public function setTaxId(string $taxId): void
    {
        $this->taxId = $taxId;
    }

    /**
     * Returns Tax Id Type.
     * The customer's tax ID type.
     */
    public function getTaxIdType(): string
    {
        return $this->taxIdType;
    }

    /**
     * Sets Tax Id Type.
     * The customer's tax ID type.
     *
     * @required
     * @maps tax_id_type
     */
    public function setTaxIdType(string $taxIdType): void
    {
        $this->taxIdType = $taxIdType;
    }

    /**
     * Converts the TaxInfo object to a human-readable string representation.
     *
     * @return string The string representation of the TaxInfo object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('TaxInfo', ['taxId' => $this->taxId, 'taxIdType' => $this->taxIdType]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['tax_id']      = $this->taxId;
        $json['tax_id_type'] = $this->taxIdType;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
