<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The capture identification-related fields. Includes the invoice ID, custom ID, note to payer, and
 * soft descriptor.
 */
class SupplementaryPurchaseData implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $invoiceId;

    /**
     * @var string|null
     */
    private $noteToPayer;

    /**
     * Returns Invoice Id.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     */
    public function getInvoiceId(): ?string
    {
        return $this->invoiceId;
    }

    /**
     * Sets Invoice Id.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     *
     * @maps invoice_id
     */
    public function setInvoiceId(?string $invoiceId): void
    {
        $this->invoiceId = $invoiceId;
    }

    /**
     * Returns Note to Payer.
     * An informational note about this settlement. Appears in both the payer's transaction history and the
     * emails that the payer receives.
     */
    public function getNoteToPayer(): ?string
    {
        return $this->noteToPayer;
    }

    /**
     * Sets Note to Payer.
     * An informational note about this settlement. Appears in both the payer's transaction history and the
     * emails that the payer receives.
     *
     * @maps note_to_payer
     */
    public function setNoteToPayer(?string $noteToPayer): void
    {
        $this->noteToPayer = $noteToPayer;
    }

    /**
     * Converts the SupplementaryPurchaseData object to a human-readable string representation.
     *
     * @return string The string representation of the SupplementaryPurchaseData object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SupplementaryPurchaseData',
            ['invoiceId' => $this->invoiceId, 'noteToPayer' => $this->noteToPayer]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->invoiceId)) {
            $json['invoice_id']    = $this->invoiceId;
        }
        if (isset($this->noteToPayer)) {
            $json['note_to_payer'] = $this->noteToPayer;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
