<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The refund status with details.
 */
class RefundStatusWithDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $status;

    /**
     * @var RefundStatusDetails|null
     */
    private $statusDetails;

    /**
     * Returns Status.
     * The status of the refund.
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * The status of the refund.
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Status Details.
     * The details of the refund status.
     */
    public function getStatusDetails(): ?RefundStatusDetails
    {
        return $this->statusDetails;
    }

    /**
     * Sets Status Details.
     * The details of the refund status.
     *
     * @maps status_details
     */
    public function setStatusDetails(?RefundStatusDetails $statusDetails): void
    {
        $this->statusDetails = $statusDetails;
    }

    /**
     * Converts the RefundStatusWithDetails object to a human-readable string representation.
     *
     * @return string The string representation of the RefundStatusWithDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'RefundStatusWithDetails',
            ['status' => $this->status, 'statusDetails' => $this->statusDetails]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->status)) {
            $json['status']         = $this->status;
        }
        if (isset($this->statusDetails)) {
            $json['status_details'] = $this->statusDetails;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
