<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The collection of payments, or transactions, for a purchase unit in an order. For example,
 * authorized payments, captured payments, and refunds.
 */
class PaymentCollection implements \JsonSerializable
{
    /**
     * @var AuthorizationWithAdditionalData[]|null
     */
    private $authorizations;

    /**
     * @var OrdersCapture[]|null
     */
    private $captures;

    /**
     * @var Refund[]|null
     */
    private $refunds;

    /**
     * Returns Authorizations.
     * An array of authorized payments for a purchase unit. A purchase unit can have zero or more
     * authorized payments.
     *
     * @return AuthorizationWithAdditionalData[]|null
     */
    public function getAuthorizations(): ?array
    {
        return $this->authorizations;
    }

    /**
     * Sets Authorizations.
     * An array of authorized payments for a purchase unit. A purchase unit can have zero or more
     * authorized payments.
     *
     * @maps authorizations
     *
     * @param AuthorizationWithAdditionalData[]|null $authorizations
     */
    public function setAuthorizations(?array $authorizations): void
    {
        $this->authorizations = $authorizations;
    }

    /**
     * Returns Captures.
     * An array of captured payments for a purchase unit. A purchase unit can have zero or more captured
     * payments.
     *
     * @return OrdersCapture[]|null
     */
    public function getCaptures(): ?array
    {
        return $this->captures;
    }

    /**
     * Sets Captures.
     * An array of captured payments for a purchase unit. A purchase unit can have zero or more captured
     * payments.
     *
     * @maps captures
     *
     * @param OrdersCapture[]|null $captures
     */
    public function setCaptures(?array $captures): void
    {
        $this->captures = $captures;
    }

    /**
     * Returns Refunds.
     * An array of refunds for a purchase unit. A purchase unit can have zero or more refunds.
     *
     * @return Refund[]|null
     */
    public function getRefunds(): ?array
    {
        return $this->refunds;
    }

    /**
     * Sets Refunds.
     * An array of refunds for a purchase unit. A purchase unit can have zero or more refunds.
     *
     * @maps refunds
     *
     * @param Refund[]|null $refunds
     */
    public function setRefunds(?array $refunds): void
    {
        $this->refunds = $refunds;
    }

    /**
     * Converts the PaymentCollection object to a human-readable string representation.
     *
     * @return string The string representation of the PaymentCollection object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaymentCollection',
            ['authorizations' => $this->authorizations, 'captures' => $this->captures, 'refunds' => $this->refunds]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->authorizations)) {
            $json['authorizations'] = $this->authorizations;
        }
        if (isset($this->captures)) {
            $json['captures']       = $this->captures;
        }
        if (isset($this->refunds)) {
            $json['refunds']        = $this->refunds;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
