<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * CallBack Configuration that the merchant can provide to PayPal/Venmo.
 */
class CallbackConfiguration implements \JsonSerializable
{
    /**
     * @var string[]
     */
    private $callbackEvents;

    /**
     * @var string
     */
    private $callbackUrl;

    /**
     * @param string[] $callbackEvents
     * @param string $callbackUrl
     */
    public function __construct(array $callbackEvents, string $callbackUrl)
    {
        $this->callbackEvents = $callbackEvents;
        $this->callbackUrl = $callbackUrl;
    }

    /**
     * Returns Callback Events.
     * An array of callback events merchant can subscribe to for the corresponding callback url. The
     * SHIPPING_ADDRESS callback event is required.
     *
     * @return string[]
     */
    public function getCallbackEvents(): array
    {
        return $this->callbackEvents;
    }

    /**
     * Sets Callback Events.
     * An array of callback events merchant can subscribe to for the corresponding callback url. The
     * SHIPPING_ADDRESS callback event is required.
     *
     * @required
     * @maps callback_events
     *
     * @param string[] $callbackEvents
     */
    public function setCallbackEvents(array $callbackEvents): void
    {
        $this->callbackEvents = $callbackEvents;
    }

    /**
     * Returns Callback Url.
     * Merchant provided CallBack url.PayPal/Venmo will use this url to call the merchant back when the
     * events occur .PayPal/Venmo expects a secured url usually in the https format.merchant can append the
     * cart id or other params part of the url as query or path params.
     */
    public function getCallbackUrl(): string
    {
        return $this->callbackUrl;
    }

    /**
     * Sets Callback Url.
     * Merchant provided CallBack url.PayPal/Venmo will use this url to call the merchant back when the
     * events occur .PayPal/Venmo expects a secured url usually in the https format.merchant can append the
     * cart id or other params part of the url as query or path params.
     *
     * @required
     * @maps callback_url
     */
    public function setCallbackUrl(string $callbackUrl): void
    {
        $this->callbackUrl = $callbackUrl;
    }

    /**
     * Converts the CallbackConfiguration object to a human-readable string representation.
     *
     * @return string The string representation of the CallbackConfiguration object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CallbackConfiguration',
            ['callbackEvents' => $this->callbackEvents, 'callbackUrl' => $this->callbackUrl]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['callback_events'] = $this->callbackEvents;
        $json['callback_url']    = $this->callbackUrl;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
