<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultedDigitalWallet;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;

/**
 * Builder for model VaultedDigitalWallet
 *
 * @see VaultedDigitalWallet
 */
class VaultedDigitalWalletBuilder
{
    /**
     * @var VaultedDigitalWallet
     */
    private $instance;

    private function __construct(VaultedDigitalWallet $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vaulted Digital Wallet Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultedDigitalWallet());
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets shipping field.
     *
     * @param VaultedDigitalWalletShippingDetails|null $value
     */
    public function shipping(?VaultedDigitalWalletShippingDetails $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     *
     * @param bool|null $value
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Sets usage type field.
     *
     * @param string|null $value
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     *
     * @param string|null $value
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Initializes a new Vaulted Digital Wallet object.
     */
    public function build(): VaultedDigitalWallet
    {
        return CoreHelper::clone($this->instance);
    }
}
