<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AuthorizationStatusDetails;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\NetworkTransactionReference;
use PaypalServerSdkLib\Models\PayeeBase;
use PaypalServerSdkLib\Models\PaymentAuthorization;
use PaypalServerSdkLib\Models\PaymentSupplementaryData;
use PaypalServerSdkLib\Models\SellerProtection;

/**
 * Builder for model PaymentAuthorization
 *
 * @see PaymentAuthorization
 */
class PaymentAuthorizationBuilder
{
    /**
     * @var PaymentAuthorization
     */
    private $instance;

    private function __construct(PaymentAuthorization $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Payment Authorization Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentAuthorization());
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets status details field.
     *
     * @param AuthorizationStatusDetails|null $value
     */
    public function statusDetails(?AuthorizationStatusDetails $value): self
    {
        $this->instance->setStatusDetails($value);
        return $this;
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets invoice id field.
     *
     * @param string|null $value
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets custom id field.
     *
     * @param string|null $value
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets network transaction reference field.
     *
     * @param NetworkTransactionReference|null $value
     */
    public function networkTransactionReference(?NetworkTransactionReference $value): self
    {
        $this->instance->setNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Sets seller protection field.
     *
     * @param SellerProtection|null $value
     */
    public function sellerProtection(?SellerProtection $value): self
    {
        $this->instance->setSellerProtection($value);
        return $this;
    }

    /**
     * Sets expiration time field.
     *
     * @param string|null $value
     */
    public function expirationTime(?string $value): self
    {
        $this->instance->setExpirationTime($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Sets supplementary data field.
     *
     * @param PaymentSupplementaryData|null $value
     */
    public function supplementaryData(?PaymentSupplementaryData $value): self
    {
        $this->instance->setSupplementaryData($value);
        return $this;
    }

    /**
     * Sets payee field.
     *
     * @param PayeeBase|null $value
     */
    public function payee(?PayeeBase $value): self
    {
        $this->instance->setPayee($value);
        return $this;
    }

    /**
     * Initializes a new Payment Authorization object.
     */
    public function build(): PaymentAuthorization
    {
        return CoreHelper::clone($this->instance);
    }
}
