<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LineItem;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\UniversalProductCode;

/**
 * Builder for model LineItem
 *
 * @see LineItem
 */
class LineItemBuilder
{
    /**
     * @var LineItem
     */
    private $instance;

    private function __construct(LineItem $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Line Item Builder object.
     *
     * @param string $name
     * @param string $quantity
     */
    public static function init(string $name, string $quantity): self
    {
        return new self(new LineItem($name, $quantity));
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets sku field.
     *
     * @param string|null $value
     */
    public function sku(?string $value): self
    {
        $this->instance->setSku($value);
        return $this;
    }

    /**
     * Sets url field.
     *
     * @param string|null $value
     */
    public function url(?string $value): self
    {
        $this->instance->setUrl($value);
        return $this;
    }

    /**
     * Sets image url field.
     *
     * @param string|null $value
     */
    public function imageUrl(?string $value): self
    {
        $this->instance->setImageUrl($value);
        return $this;
    }

    /**
     * Sets upc field.
     *
     * @param UniversalProductCode|null $value
     */
    public function upc(?UniversalProductCode $value): self
    {
        $this->instance->setUpc($value);
        return $this;
    }

    /**
     * Sets unit amount field.
     *
     * @param Money|null $value
     */
    public function unitAmount(?Money $value): self
    {
        $this->instance->setUnitAmount($value);
        return $this;
    }

    /**
     * Sets tax field.
     *
     * @param Money|null $value
     */
    public function tax(?Money $value): self
    {
        $this->instance->setTax($value);
        return $this;
    }

    /**
     * Sets commodity code field.
     *
     * @param string|null $value
     */
    public function commodityCode(?string $value): self
    {
        $this->instance->setCommodityCode($value);
        return $this;
    }

    /**
     * Sets discount amount field.
     *
     * @param Money|null $value
     */
    public function discountAmount(?Money $value): self
    {
        $this->instance->setDiscountAmount($value);
        return $this;
    }

    /**
     * Sets total amount field.
     *
     * @param Money|null $value
     */
    public function totalAmount(?Money $value): self
    {
        $this->instance->setTotalAmount($value);
        return $this;
    }

    /**
     * Sets unit of measure field.
     *
     * @param string|null $value
     */
    public function unitOfMeasure(?string $value): self
    {
        $this->instance->setUnitOfMeasure($value);
        return $this;
    }

    /**
     * Initializes a new Line Item object.
     */
    public function build(): LineItem
    {
        return CoreHelper::clone($this->instance);
    }
}
