<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CapturePaymentInstruction;
use PaypalServerSdkLib\Models\CaptureRequest;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model CaptureRequest
 *
 * @see CaptureRequest
 */
class CaptureRequestBuilder
{
    /**
     * @var CaptureRequest
     */
    private $instance;

    private function __construct(CaptureRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Capture Request Builder object.
     */
    public static function init(): self
    {
        return new self(new CaptureRequest());
    }

    /**
     * Sets invoice id field.
     *
     * @param string|null $value
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets note to payer field.
     *
     * @param string|null $value
     */
    public function noteToPayer(?string $value): self
    {
        $this->instance->setNoteToPayer($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets final capture field.
     *
     * @param bool|null $value
     */
    public function finalCapture(?bool $value): self
    {
        $this->instance->setFinalCapture($value);
        return $this;
    }

    /**
     * Sets payment instruction field.
     *
     * @param CapturePaymentInstruction|null $value
     */
    public function paymentInstruction(?CapturePaymentInstruction $value): self
    {
        $this->instance->setPaymentInstruction($value);
        return $this;
    }

    /**
     * Sets soft descriptor field.
     *
     * @param string|null $value
     */
    public function softDescriptor(?string $value): self
    {
        $this->instance->setSoftDescriptor($value);
        return $this;
    }

    /**
     * Initializes a new Capture Request object.
     */
    public function build(): CaptureRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
