<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Any additional payments instructions during refund payment processing. This object is only
 * applicable to merchants that have been enabled for PayPal Commerce Platform for Marketplaces and
 * Platforms capability. Please speak to your account manager if you want to use this capability.
 */
class RefundPaymentInstruction implements \JsonSerializable
{
    /**
     * @var RefundPlatformFee[]|null
     */
    private $platformFees;

    /**
     * Returns Platform Fees.
     * Specifies the amount that the API caller will contribute to the refund being processed. The amount
     * needs to be lower than platform_fees amount originally captured or the amount that is remaining if
     * multiple refunds have been processed. This field is only applicable to merchants that have been
     * enabled for PayPal Commerce Platform for Marketplaces and Platforms capability. Please speak to your
     * account manager if you want to use this capability.
     *
     * @return RefundPlatformFee[]|null
     */
    public function getPlatformFees(): ?array
    {
        return $this->platformFees;
    }

    /**
     * Sets Platform Fees.
     * Specifies the amount that the API caller will contribute to the refund being processed. The amount
     * needs to be lower than platform_fees amount originally captured or the amount that is remaining if
     * multiple refunds have been processed. This field is only applicable to merchants that have been
     * enabled for PayPal Commerce Platform for Marketplaces and Platforms capability. Please speak to your
     * account manager if you want to use this capability.
     *
     * @maps platform_fees
     *
     * @param RefundPlatformFee[]|null $platformFees
     */
    public function setPlatformFees(?array $platformFees): void
    {
        $this->platformFees = $platformFees;
    }

    /**
     * Converts the RefundPaymentInstruction object to a human-readable string representation.
     *
     * @return string The string representation of the RefundPaymentInstruction object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('RefundPaymentInstruction', ['platformFees' => $this->platformFees]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->platformFees)) {
            $json['platform_fees'] = $this->platformFees;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
