<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The merchant level Recurring Billing plan metadata for the Billing Agreement.
 */
class Plan implements \JsonSerializable
{
    /**
     * @var BillingCycle[]
     */
    private $billingCycles;

    /**
     * @var mixed
     */
    private $product;

    /**
     * @var OneTimeCharge
     */
    private $oneTimeCharges;

    /**
     * @var string|null
     */
    private $name;

    /**
     * @param BillingCycle[] $billingCycles
     * @param OneTimeCharge $oneTimeCharges
     */
    public function __construct(array $billingCycles, OneTimeCharge $oneTimeCharges)
    {
        $this->billingCycles = $billingCycles;
        $this->oneTimeCharges = $oneTimeCharges;
    }

    /**
     * Returns Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @return BillingCycle[]
     */
    public function getBillingCycles(): array
    {
        return $this->billingCycles;
    }

    /**
     * Sets Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @required
     * @maps billing_cycles
     *
     * @param BillingCycle[] $billingCycles
     */
    public function setBillingCycles(array $billingCycles): void
    {
        $this->billingCycles = $billingCycles;
    }

    /**
     * Returns Product.
     * Product details associated with any one-time product purchase.
     *
     * @return mixed
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Sets Product.
     * Product details associated with any one-time product purchase.
     *
     * @maps product
     *
     * @param mixed $product
     */
    public function setProduct($product): void
    {
        $this->product = $product;
    }

    /**
     * Returns One Time Charges.
     * The one-time charge info at the time of checkout.
     */
    public function getOneTimeCharges(): OneTimeCharge
    {
        return $this->oneTimeCharges;
    }

    /**
     * Sets One Time Charges.
     * The one-time charge info at the time of checkout.
     *
     * @required
     * @maps one_time_charges
     */
    public function setOneTimeCharges(OneTimeCharge $oneTimeCharges): void
    {
        $this->oneTimeCharges = $oneTimeCharges;
    }

    /**
     * Returns Name.
     * Name of the recurring plan.
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * Name of the recurring plan.
     *
     * @maps name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * Converts the Plan object to a human-readable string representation.
     *
     * @return string The string representation of the Plan object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'Plan',
            [
                'billingCycles' => $this->billingCycles,
                'product' => $this->product,
                'oneTimeCharges' => $this->oneTimeCharges,
                'name' => $this->name
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['billing_cycles']   = $this->billingCycles;
        if (isset($this->product)) {
            $json['product']      = $this->product;
        }
        $json['one_time_charges'] = $this->oneTimeCharges;
        if (isset($this->name)) {
            $json['name']         = $this->name;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
