<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The phone information.
 */
class PhoneWithType implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $phoneType;

    /**
     * @var PhoneNumber
     */
    private $phoneNumber;

    /**
     * @param PhoneNumber $phoneNumber
     */
    public function __construct(PhoneNumber $phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * Returns Phone Type.
     * The phone type.
     */
    public function getPhoneType(): ?string
    {
        return $this->phoneType;
    }

    /**
     * Sets Phone Type.
     * The phone type.
     *
     * @maps phone_type
     */
    public function setPhoneType(?string $phoneType): void
    {
        $this->phoneType = $phoneType;
    }

    /**
     * Returns Phone Number.
     * The phone number in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     */
    public function getPhoneNumber(): PhoneNumber
    {
        return $this->phoneNumber;
    }

    /**
     * Sets Phone Number.
     * The phone number in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     *
     * @required
     * @maps phone_number
     */
    public function setPhoneNumber(PhoneNumber $phoneNumber): void
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * Converts the PhoneWithType object to a human-readable string representation.
     *
     * @return string The string representation of the PhoneWithType object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PhoneWithType',
            ['phoneType' => $this->phoneType, 'phoneNumber' => $this->phoneNumber]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->phoneType)) {
            $json['phone_type'] = $this->phoneType;
        }
        $json['phone_number']   = $this->phoneNumber;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
