<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

class PaypalPaymentToken implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $description;

    /**
     * @var string|null
     */
    private $usagePattern;

    /**
     * @var VaultedDigitalWalletShippingDetails|null
     */
    private $shipping;

    /**
     * @var bool|null
     */
    private $permitMultiplePaymentTokens = false;

    /**
     * @var string|null
     */
    private $usageType;

    /**
     * @var string|null
     */
    private $customerType;

    /**
     * @var string|null
     */
    private $emailAddress;

    /**
     * @var string|null
     */
    private $payerId;

    /**
     * @var Name|null
     */
    private $name;

    /**
     * @var PhoneWithType|null
     */
    private $phone;

    /**
     * @var Address|null
     */
    private $address;

    /**
     * @var string|null
     */
    private $accountId;

    /**
     * @var Phone|null
     */
    private $phoneNumber;

    /**
     * Returns Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well as on
     * the merchant view of the payment token management experience. exp: PayPal.com.
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * Sets Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well as on
     * the merchant view of the payment token management experience. exp: PayPal.com.
     *
     * @maps description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * Returns Usage Pattern.
     * Expected business/charge model for the billing agreement.
     */
    public function getUsagePattern(): ?string
    {
        return $this->usagePattern;
    }

    /**
     * Sets Usage Pattern.
     * Expected business/charge model for the billing agreement.
     *
     * @maps usage_pattern
     */
    public function setUsagePattern(?string $usagePattern): void
    {
        $this->usagePattern = $usagePattern;
    }

    /**
     * Returns Shipping.
     * The shipping details.
     */
    public function getShipping(): ?VaultedDigitalWalletShippingDetails
    {
        return $this->shipping;
    }

    /**
     * Sets Shipping.
     * The shipping details.
     *
     * @maps shipping
     */
    public function setShipping(?VaultedDigitalWalletShippingDetails $shipping): void
    {
        $this->shipping = $shipping;
    }

    /**
     * Returns Permit Multiple Payment Tokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this when the
     * customer has not logged in at merchant/platform. The payment token thus generated, can then also be
     * used to create the customer account at merchant/platform. Use this also when multiple payment tokens
     * are required for the same payer, different customer at merchant/platform. This helps to identify
     * customers distinctly even though they may share the same PayPal account. This only applies to PayPal
     * payment source.
     */
    public function getPermitMultiplePaymentTokens(): ?bool
    {
        return $this->permitMultiplePaymentTokens;
    }

    /**
     * Sets Permit Multiple Payment Tokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this when the
     * customer has not logged in at merchant/platform. The payment token thus generated, can then also be
     * used to create the customer account at merchant/platform. Use this also when multiple payment tokens
     * are required for the same payer, different customer at merchant/platform. This helps to identify
     * customers distinctly even though they may share the same PayPal account. This only applies to PayPal
     * payment source.
     *
     * @maps permit_multiple_payment_tokens
     */
    public function setPermitMultiplePaymentTokens(?bool $permitMultiplePaymentTokens): void
    {
        $this->permitMultiplePaymentTokens = $permitMultiplePaymentTokens;
    }

    /**
     * Returns Usage Type.
     * The usage type associated with a digital wallet payment token.
     */
    public function getUsageType(): ?string
    {
        return $this->usageType;
    }

    /**
     * Sets Usage Type.
     * The usage type associated with a digital wallet payment token.
     *
     * @maps usage_type
     */
    public function setUsageType(?string $usageType): void
    {
        $this->usageType = $usageType;
    }

    /**
     * Returns Customer Type.
     * The customer type associated with a digital wallet payment token. This is to indicate whether the
     * customer acting on the merchant / platform is either a business or a consumer.
     */
    public function getCustomerType(): ?string
    {
        return $this->customerType;
    }

    /**
     * Sets Customer Type.
     * The customer type associated with a digital wallet payment token. This is to indicate whether the
     * customer acting on the merchant / platform is either a business or a consumer.
     *
     * @maps customer_type
     */
    public function setCustomerType(?string $customerType): void
    {
        $this->customerType = $customerType;
    }

    /**
     * Returns Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getEmailAddress(): ?string
    {
        return $this->emailAddress;
    }

    /**
     * Sets Email Address.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps email_address
     */
    public function setEmailAddress(?string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    /**
     * Returns Payer Id.
     * The account identifier for a PayPal account.
     */
    public function getPayerId(): ?string
    {
        return $this->payerId;
    }

    /**
     * Sets Payer Id.
     * The account identifier for a PayPal account.
     *
     * @maps payer_id
     */
    public function setPayerId(?string $payerId): void
    {
        $this->payerId = $payerId;
    }

    /**
     * Returns Name.
     * The name of the party.
     */
    public function getName(): ?Name
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The name of the party.
     *
     * @maps name
     */
    public function setName(?Name $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Phone.
     * The phone information.
     */
    public function getPhone(): ?PhoneWithType
    {
        return $this->phone;
    }

    /**
     * Sets Phone.
     * The phone information.
     *
     * @maps phone
     */
    public function setPhone(?PhoneWithType $phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Returns Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     */
    public function getAddress(): ?Address
    {
        return $this->address;
    }

    /**
     * Sets Address.
     * The portable international postal address. Maps to [AddressValidationMetadata](https://github.
     * com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form
     * controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-
     * controls-the-autocomplete-attribute).
     *
     * @maps address
     */
    public function setAddress(?Address $address): void
    {
        $this->address = $address;
    }

    /**
     * Returns Account Id.
     * The account identifier for a PayPal account.
     */
    public function getAccountId(): ?string
    {
        return $this->accountId;
    }

    /**
     * Sets Account Id.
     * The account identifier for a PayPal account.
     *
     * @maps account_id
     */
    public function setAccountId(?string $accountId): void
    {
        $this->accountId = $accountId;
    }

    /**
     * Returns Phone Number.
     * The phone number, in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     */
    public function getPhoneNumber(): ?Phone
    {
        return $this->phoneNumber;
    }

    /**
     * Sets Phone Number.
     * The phone number, in its canonical international [E.164 numbering plan format](https://www.itu.
     * int/rec/T-REC-E.164/en).
     *
     * @maps phone_number
     */
    public function setPhoneNumber(?Phone $phoneNumber): void
    {
        $this->phoneNumber = $phoneNumber;
    }

    /**
     * Converts the PaypalPaymentToken object to a human-readable string representation.
     *
     * @return string The string representation of the PaypalPaymentToken object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaypalPaymentToken',
            [
                'description' => $this->description,
                'usagePattern' => $this->usagePattern,
                'shipping' => $this->shipping,
                'permitMultiplePaymentTokens' => $this->permitMultiplePaymentTokens,
                'usageType' => $this->usageType,
                'customerType' => $this->customerType,
                'emailAddress' => $this->emailAddress,
                'payerId' => $this->payerId,
                'name' => $this->name,
                'phone' => $this->phone,
                'address' => $this->address,
                'accountId' => $this->accountId,
                'phoneNumber' => $this->phoneNumber
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->description)) {
            $json['description']                    = $this->description;
        }
        if (isset($this->usagePattern)) {
            $json['usage_pattern']                  = $this->usagePattern;
        }
        if (isset($this->shipping)) {
            $json['shipping']                       = $this->shipping;
        }
        if (isset($this->permitMultiplePaymentTokens)) {
            $json['permit_multiple_payment_tokens'] = $this->permitMultiplePaymentTokens;
        }
        if (isset($this->usageType)) {
            $json['usage_type']                     = $this->usageType;
        }
        if (isset($this->customerType)) {
            $json['customer_type']                  = $this->customerType;
        }
        if (isset($this->emailAddress)) {
            $json['email_address']                  = $this->emailAddress;
        }
        if (isset($this->payerId)) {
            $json['payer_id']                       = $this->payerId;
        }
        if (isset($this->name)) {
            $json['name']                           = $this->name;
        }
        if (isset($this->phone)) {
            $json['phone']                          = $this->phone;
        }
        if (isset($this->address)) {
            $json['address']                        = $this->address;
        }
        if (isset($this->accountId)) {
            $json['account_id']                     = $this->accountId;
        }
        if (isset($this->phoneNumber)) {
            $json['phone_number']                   = $this->phoneNumber;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
