<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The error details. Required for client-side `4XX` errors.
 */
class ErrorDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $field;

    /**
     * @var string|null
     */
    private $value;

    /**
     * @var string|null
     */
    private $location = 'body';

    /**
     * @var string
     */
    private $issue;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @param string $issue
     */
    public function __construct(string $issue)
    {
        $this->issue = $issue;
    }

    /**
     * Returns Field.
     * The field that caused the error. If this field is in the body, set this value to the field's JSON
     * pointer value. Required for client-side errors.
     */
    public function getField(): ?string
    {
        return $this->field;
    }

    /**
     * Sets Field.
     * The field that caused the error. If this field is in the body, set this value to the field's JSON
     * pointer value. Required for client-side errors.
     *
     * @maps field
     */
    public function setField(?string $field): void
    {
        $this->field = $field;
    }

    /**
     * Returns Value.
     * The value of the field that caused the error.
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * Sets Value.
     * The value of the field that caused the error.
     *
     * @maps value
     */
    public function setValue(?string $value): void
    {
        $this->value = $value;
    }

    /**
     * Returns Location.
     * The location of the field that caused the error. Value is `body`, `path`, or `query`.
     */
    public function getLocation(): ?string
    {
        return $this->location;
    }

    /**
     * Sets Location.
     * The location of the field that caused the error. Value is `body`, `path`, or `query`.
     *
     * @maps location
     */
    public function setLocation(?string $location): void
    {
        $this->location = $location;
    }

    /**
     * Returns Issue.
     * The unique, fine-grained application-level error code.
     */
    public function getIssue(): string
    {
        return $this->issue;
    }

    /**
     * Sets Issue.
     * The unique, fine-grained application-level error code.
     *
     * @required
     * @maps issue
     */
    public function setIssue(string $issue): void
    {
        $this->issue = $issue;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links) that are either
     * relevant to the issue by providing additional information or offering potential resolutions.
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links) that are either
     * relevant to the issue by providing additional information or offering potential resolutions.
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Returns Description.
     * The human-readable description for an issue. The description can change over the lifetime of an API,
     * so clients must not depend on this value.
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * Sets Description.
     * The human-readable description for an issue. The description can change over the lifetime of an API,
     * so clients must not depend on this value.
     *
     * @maps description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * Converts the ErrorDetails object to a human-readable string representation.
     *
     * @return string The string representation of the ErrorDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ErrorDetails',
            [
                'field' => $this->field,
                'value' => $this->value,
                'location' => $this->location,
                'issue' => $this->issue,
                'links' => $this->links,
                'description' => $this->description
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->field)) {
            $json['field']       = $this->field;
        }
        if (isset($this->value)) {
            $json['value']       = $this->value;
        }
        if (isset($this->location)) {
            $json['location']    = $this->location;
        }
        $json['issue']           = $this->issue;
        if (isset($this->links)) {
            $json['links']       = $this->links;
        }
        if (isset($this->description)) {
            $json['description'] = $this->description;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
