<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Details about the merchant cobranded card used for order purchase.
 */
class CobrandedCard implements \JsonSerializable
{
    /**
     * @var string[]|null
     */
    private $labels;

    /**
     * @var PayeeBase|null
     */
    private $payee;

    /**
     * @var Money|null
     */
    private $amount;

    /**
     * Returns Labels.
     * Array of labels for the cobranded card.
     *
     * @return string[]|null
     */
    public function getLabels(): ?array
    {
        return $this->labels;
    }

    /**
     * Sets Labels.
     * Array of labels for the cobranded card.
     *
     * @maps labels
     *
     * @param string[]|null $labels
     */
    public function setLabels(?array $labels): void
    {
        $this->labels = $labels;
    }

    /**
     * Returns Payee.
     * The details for the merchant who receives the funds and fulfills the order. The merchant is also
     * known as the payee.
     */
    public function getPayee(): ?PayeeBase
    {
        return $this->payee;
    }

    /**
     * Sets Payee.
     * The details for the merchant who receives the funds and fulfills the order. The merchant is also
     * known as the payee.
     *
     * @maps payee
     */
    public function setPayee(?PayeeBase $payee): void
    {
        $this->payee = $payee;
    }

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): ?Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps amount
     */
    public function setAmount(?Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Converts the CobrandedCard object to a human-readable string representation.
     *
     * @return string The string representation of the CobrandedCard object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CobrandedCard',
            ['labels' => $this->labels, 'payee' => $this->payee, 'amount' => $this->amount]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->labels)) {
            $json['labels'] = $this->labels;
        }
        if (isset($this->payee)) {
            $json['payee']  = $this->payee;
        }
        if (isset($this->amount)) {
            $json['amount'] = $this->amount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
