<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Provides additional details to process a payment using a `card` that has been stored or is intended
 * to be stored (also referred to as stored_credential or card-on-file). Parameter compatibility:
 * `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`. `usage=FIRST` is
 * compatible only with `payment_initiator=CUSTOMER`. `previous_transaction_reference` or
 * `previous_network_transaction_reference` is compatible only with `payment_initiator=MERCHANT`. Only
 * one of the parameters - `previous_transaction_reference` and
 * `previous_network_transaction_reference` - can be present in the request.
 */
class CardStoredCredential implements \JsonSerializable
{
    /**
     * @var string
     */
    private $paymentInitiator;

    /**
     * @var string
     */
    private $paymentType;

    /**
     * @var string|null
     */
    private $usage = StoredPaymentSourceUsageType::DERIVED;

    /**
     * @var NetworkTransactionReference|null
     */
    private $previousNetworkTransactionReference;

    /**
     * @param string $paymentInitiator
     * @param string $paymentType
     */
    public function __construct(string $paymentInitiator, string $paymentType)
    {
        $this->paymentInitiator = $paymentInitiator;
        $this->paymentType = $paymentType;
    }

    /**
     * Returns Payment Initiator.
     * The person or party who initiated or triggered the payment.
     */
    public function getPaymentInitiator(): string
    {
        return $this->paymentInitiator;
    }

    /**
     * Sets Payment Initiator.
     * The person or party who initiated or triggered the payment.
     *
     * @required
     * @maps payment_initiator
     */
    public function setPaymentInitiator(string $paymentInitiator): void
    {
        $this->paymentInitiator = $paymentInitiator;
    }

    /**
     * Returns Payment Type.
     * Indicates the type of the stored payment_source payment.
     */
    public function getPaymentType(): string
    {
        return $this->paymentType;
    }

    /**
     * Sets Payment Type.
     * Indicates the type of the stored payment_source payment.
     *
     * @required
     * @maps payment_type
     */
    public function setPaymentType(string $paymentType): void
    {
        $this->paymentType = $paymentType;
    }

    /**
     * Returns Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also referred
     * to as stored credential or card on file).
     */
    public function getUsage(): ?string
    {
        return $this->usage;
    }

    /**
     * Sets Usage.
     * Indicates if this is a `first` or `subsequent` payment using a stored payment source (also referred
     * to as stored credential or card on file).
     *
     * @maps usage
     */
    public function setUsage(?string $usage): void
    {
        $this->usage = $usage;
    }

    /**
     * Returns Previous Network Transaction Reference.
     * Reference values used by the card network to identify a transaction.
     */
    public function getPreviousNetworkTransactionReference(): ?NetworkTransactionReference
    {
        return $this->previousNetworkTransactionReference;
    }

    /**
     * Sets Previous Network Transaction Reference.
     * Reference values used by the card network to identify a transaction.
     *
     * @maps previous_network_transaction_reference
     */
    public function setPreviousNetworkTransactionReference(
        ?NetworkTransactionReference $previousNetworkTransactionReference
    ): void {
        $this->previousNetworkTransactionReference = $previousNetworkTransactionReference;
    }

    /**
     * Converts the CardStoredCredential object to a human-readable string representation.
     *
     * @return string The string representation of the CardStoredCredential object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CardStoredCredential',
            [
                'paymentInitiator' => $this->paymentInitiator,
                'paymentType' => $this->paymentType,
                'usage' => $this->usage,
                'previousNetworkTransactionReference' => $this->previousNetworkTransactionReference
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['payment_initiator']                          = $this->paymentInitiator;
        $json['payment_type']                               = $this->paymentType;
        if (isset($this->usage)) {
            $json['usage']                                  = $this->usage;
        }
        if (isset($this->previousNetworkTransactionReference)) {
            $json['previous_network_transaction_reference'] = $this->previousNetworkTransactionReference;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
