<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ThreeDSecureCardAuthenticationResponse;

/**
 * Builder for model ThreeDSecureCardAuthenticationResponse
 *
 * @see ThreeDSecureCardAuthenticationResponse
 */
class ThreeDSecureCardAuthenticationResponseBuilder
{
    /**
     * @var ThreeDSecureCardAuthenticationResponse
     */
    private $instance;

    private function __construct(ThreeDSecureCardAuthenticationResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Three D Secure Card Authentication Response Builder object.
     */
    public static function init(): self
    {
        return new self(new ThreeDSecureCardAuthenticationResponse());
    }

    /**
     * Sets authentication status field.
     *
     * @param string|null $value
     */
    public function authenticationStatus(?string $value): self
    {
        $this->instance->setAuthenticationStatus($value);
        return $this;
    }

    /**
     * Sets enrollment status field.
     *
     * @param string|null $value
     */
    public function enrollmentStatus(?string $value): self
    {
        $this->instance->setEnrollmentStatus($value);
        return $this;
    }

    /**
     * Sets authentication id field.
     *
     * @param string|null $value
     */
    public function authenticationId(?string $value): self
    {
        $this->instance->setAuthenticationId($value);
        return $this;
    }

    /**
     * Initializes a new Three D Secure Card Authentication Response object.
     */
    public function build(): ThreeDSecureCardAuthenticationResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
