<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PricingScheme;

/**
 * Builder for model PricingScheme
 *
 * @see PricingScheme
 */
class PricingSchemeBuilder
{
    /**
     * @var PricingScheme
     */
    private $instance;

    private function __construct(PricingScheme $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Pricing Scheme Builder object.
     *
     * @param string $pricingModel
     */
    public static function init(string $pricingModel): self
    {
        return new self(new PricingScheme($pricingModel));
    }

    /**
     * Sets price field.
     *
     * @param Money|null $value
     */
    public function price(?Money $value): self
    {
        $this->instance->setPrice($value);
        return $this;
    }

    /**
     * Sets reload threshold amount field.
     *
     * @param Money|null $value
     */
    public function reloadThresholdAmount(?Money $value): self
    {
        $this->instance->setReloadThresholdAmount($value);
        return $this;
    }

    /**
     * Initializes a new Pricing Scheme object.
     */
    public function build(): PricingScheme
    {
        return CoreHelper::clone($this->instance);
    }
}
