<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\PaypalWallet;
use PaypalServerSdkLib\Models\PaypalWalletAttributes;
use PaypalServerSdkLib\Models\PaypalWalletExperienceContext;
use PaypalServerSdkLib\Models\PaypalWalletStoredCredential;
use PaypalServerSdkLib\Models\PhoneWithType;
use PaypalServerSdkLib\Models\TaxInfo;

/**
 * Builder for model PaypalWallet
 *
 * @see PaypalWallet
 */
class PaypalWalletBuilder
{
    /**
     * @var PaypalWallet
     */
    private $instance;

    private function __construct(PaypalWallet $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Paypal Wallet Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWallet());
    }

    /**
     * Sets vault id field.
     *
     * @param string|null $value
     */
    public function vaultId(?string $value): self
    {
        $this->instance->setVaultId($value);
        return $this;
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets phone field.
     *
     * @param PhoneWithType|null $value
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets birth date field.
     *
     * @param string|null $value
     */
    public function birthDate(?string $value): self
    {
        $this->instance->setBirthDate($value);
        return $this;
    }

    /**
     * Sets tax info field.
     *
     * @param TaxInfo|null $value
     */
    public function taxInfo(?TaxInfo $value): self
    {
        $this->instance->setTaxInfo($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param Address|null $value
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Sets attributes field.
     *
     * @param PaypalWalletAttributes|null $value
     */
    public function attributes(?PaypalWalletAttributes $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Sets experience context field.
     *
     * @param PaypalWalletExperienceContext|null $value
     */
    public function experienceContext(?PaypalWalletExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Sets billing agreement id field.
     *
     * @param string|null $value
     */
    public function billingAgreementId(?string $value): self
    {
        $this->instance->setBillingAgreementId($value);
        return $this;
    }

    /**
     * Sets stored credential field.
     *
     * @param PaypalWalletStoredCredential|null $value
     */
    public function storedCredential(?PaypalWalletStoredCredential $value): self
    {
        $this->instance->setStoredCredential($value);
        return $this;
    }

    /**
     * Initializes a new Paypal Wallet object.
     */
    public function build(): PaypalWallet
    {
        return CoreHelper::clone($this->instance);
    }
}
