<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderUpdateCallbackErrorResponse;
use PaypalServerSdkLib\Models\OrderUpdateCallbackErrorResponseDetails;

/**
 * Builder for model OrderUpdateCallbackErrorResponse
 *
 * @see OrderUpdateCallbackErrorResponse
 */
class OrderUpdateCallbackErrorResponseBuilder
{
    /**
     * @var OrderUpdateCallbackErrorResponse
     */
    private $instance;

    private function __construct(OrderUpdateCallbackErrorResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Update Callback Error Response Builder object.
     *
     * @param string $name
     */
    public static function init(string $name): self
    {
        return new self(new OrderUpdateCallbackErrorResponse($name));
    }

    /**
     * Sets message field.
     *
     * @param string|null $value
     */
    public function message(?string $value): self
    {
        $this->instance->setMessage($value);
        return $this;
    }

    /**
     * Sets details field.
     *
     * @param OrderUpdateCallbackErrorResponseDetails[]|null $value
     */
    public function details(?array $value): self
    {
        $this->instance->setDetails($value);
        return $this;
    }

    /**
     * Initializes a new Order Update Callback Error Response object.
     */
    public function build(): OrderUpdateCallbackErrorResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
