<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderTrackerItem;
use PaypalServerSdkLib\Models\OrderTrackerRequest;

/**
 * Builder for model OrderTrackerRequest
 *
 * @see OrderTrackerRequest
 */
class OrderTrackerRequestBuilder
{
    /**
     * @var OrderTrackerRequest
     */
    private $instance;

    private function __construct(OrderTrackerRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Tracker Request Builder object.
     *
     * @param string $captureId
     */
    public static function init(string $captureId): self
    {
        return new self(new OrderTrackerRequest($captureId));
    }

    /**
     * Sets tracking number field.
     *
     * @param string|null $value
     */
    public function trackingNumber(?string $value): self
    {
        $this->instance->setTrackingNumber($value);
        return $this;
    }

    /**
     * Sets carrier field.
     *
     * @param string|null $value
     */
    public function carrier(?string $value): self
    {
        $this->instance->setCarrier($value);
        return $this;
    }

    /**
     * Sets carrier name other field.
     *
     * @param string|null $value
     */
    public function carrierNameOther(?string $value): self
    {
        $this->instance->setCarrierNameOther($value);
        return $this;
    }

    /**
     * Sets notify payer field.
     *
     * @param bool|null $value
     */
    public function notifyPayer(?bool $value): self
    {
        $this->instance->setNotifyPayer($value);
        return $this;
    }

    /**
     * Sets items field.
     *
     * @param OrderTrackerItem[]|null $value
     */
    public function items(?array $value): self
    {
        $this->instance->setItems($value);
        return $this;
    }

    /**
     * Initializes a new Order Tracker Request object.
     */
    public function build(): OrderTrackerRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
