<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\ApplePayCard;

/**
 * Builder for model ApplePayCard
 *
 * @see ApplePayCard
 */
class ApplePayCardBuilder
{
    /**
     * @var ApplePayCard
     */
    private $instance;

    private function __construct(ApplePayCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Apple Pay Card Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayCard());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets last digits field.
     *
     * @param string|null $value
     */
    public function lastDigits(?string $value): self
    {
        $this->instance->setLastDigits($value);
        return $this;
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets brand field.
     *
     * @param string|null $value
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     *
     * @param Address|null $value
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Initializes a new Apple Pay Card object.
     */
    public function build(): ApplePayCard
    {
        return CoreHelper::clone($this->instance);
    }
}
